#include "c4d_basesound.h"
#include "c4d_file.h"
#include "operatingsystem.h"

BaseSound *BaseSound::GetClone(void)
{
	return C4DOS.Bu->GetClone(this);
}

Bool BaseSound::CopyTo(BaseSound *dest)
{
	return C4DOS.Bu->CopyTo(this,dest);
}

Bool BaseSound::Init(LONG samples, LONG fmode, Bool stereo, Bool b16)
{
	return C4DOS.Bu->Init(this,samples,fmode,stereo,b16);
}

void BaseSound::FlushAll(void)
{
	C4DOS.Bu->FlushAll(this);
}

Bool BaseSound::Load(const Filename &fn)
{
	return C4DOS.Bu->Load(this,&fn);
}

Bool BaseSound::Save(const Filename &fn)
{
	return C4DOS.Bu->Save(this,&fn);
}

void BaseSound::GetSoundInfo(Bool *stereo, Bool *b16, LONG *frequency, LONG *samples, BaseTime *length)
{
	C4DOS.Bu->GetSoundInfo(this,stereo,b16,frequency,samples,length);
}

CHAR *BaseSound::GetRAW(void)
{
	return C4DOS.Bu->GetRAW(this);
}

void BaseSound::GetSample(LONG i, SData *data)
{
	C4DOS.Bu->GetSample(this,i,data);
}

void BaseSound::SetSample(LONG i, const SData &data)
{
	C4DOS.Bu->SetSample(this,i,(SData*)&data);
}

BaseBitmap *BaseSound::GetBitmap(LONG width, LONG height, const BaseTime &start, const BaseTime &stop)
{
	return C4DOS.Bu->GetBitmap(this,width,height,start,stop);
}

BaseKey *BaseSound::GetFirstMarker(void)
{
	return C4DOS.Bu->GetFirstMarker(this);
}

Bool BaseSound::InsertMarker(BaseKey *mk, BaseKey *pred)
{
	return C4DOS.Bu->InsertMarker(this,mk,pred);
}

BaseSound *BaseSound::Alloc(void)
{
	return C4DOS.Bu->Alloc();
}

void BaseSound::Free(BaseSound *&bs)
{
	C4DOS.Bu->Free(bs);
	bs=NULL;
}
